(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     85034,       1736]
NotebookOptionsPosition[     82046,       1634]
NotebookOutlinePosition[     82655,       1656]
CellTagsIndexPosition[     82612,       1653]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , finite length reflective diffusion",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9, {3.570553977298891*^9, 3.570553984193285*^9}, {
   3.570796493918581*^9, 3.570796494859635*^9}, {3.570806877226472*^9, 
   3.570806895420513*^9}, {3.5708146785726833`*^9, 3.5708146831169434`*^9}, {
   3.570815424029321*^9, 3.570815424509349*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cdl\"\>", ",", "\<\"Co\"\>", ",", "\<\"Dox\"\>", 
   ",", "\<\"F\"\>", ",", "\<\"function$$\"\>", ",", "\<\"l\"\>", 
   ",", "\<\"oldPacletURI$$\"\>", ",", "\<\"R\"\>", ",", "\<\"Rct\"\>", 
   ",", "\<\"Rs\"\>", ",", "\<\"T\"\>", ",", "\<\"Z\"\>", ",", "\<\"Zf\"\>", 
   ",", "\<\"Zw\"\>", ",", "\<\"\[Sigma]\"\>", ",", "\<\"\[Omega]\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9, 
   3.57053934340388*^9, 3.570555127082655*^9, 3.5705553201646986`*^9, 
   3.5705555073474045`*^9, 3.5705555648816957`*^9, 3.5705571982221174`*^9, 
   3.570557235474248*^9, 3.5705572710812845`*^9, 3.570557954506374*^9, {
   3.5705580936843348`*^9, 3.57055813259256*^9}, 3.5707965547220583`*^9, 
   3.5708073488754487`*^9, 3.570807449685215*^9, {3.5708147142597246`*^9, 
   3.5708147320947447`*^9}, 3.570814824127009*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Sigma]", "=", 
  RowBox[{"R", "*", 
   RowBox[{"T", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["F", "2"], "*", "Co", "*", 
      RowBox[{"Sqrt", "[", "Dox", "]"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}, {3.5705383096987553`*^9, 3.570538399684902*^9}, {
   3.570538455217078*^9, 3.5705385242120247`*^9}, {3.5705385781811113`*^9, 
   3.5705386130431056`*^9}, {3.5705386973959303`*^9, 
   3.5705388328526783`*^9}, {3.5705388686457253`*^9, 
   3.5705388937151594`*^9}, {3.5705539935738215`*^9, 
   3.5705540484529605`*^9}, {3.570814719280012*^9, 3.5708147288465595`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T"}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"]}]]], "Output",
 CellChangeTimes->{
  3.5705388964243145`*^9, 3.5705393435168867`*^9, 3.5705540511101127`*^9, 
   3.570555127196661*^9, 3.5705553203117065`*^9, 3.570555514380807*^9, 
   3.5705555650777063`*^9, 3.5705571983761263`*^9, 3.570557235591254*^9, 
   3.5705572711862907`*^9, 3.5705579546343813`*^9, {3.5705580938113422`*^9, 
   3.5705581327385683`*^9}, 3.5707965657976923`*^9, 3.5708073489944553`*^9, 
   3.570807449798221*^9, 3.5708147354439363`*^9, 3.5708148242310147`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zw", "=", 
  RowBox[{"\[Sigma]", "*", 
   RowBox[{
    RowBox[{"Coth", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"\[ImaginaryI]", "*", 
        RowBox[{"\[Omega]", "/", "Dox"}]}], "]"}], "*", "l"}], "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5705392072310915`*^9, 3.5705392132664366`*^9}, {
  3.5705540591705737`*^9, 3.5705543167563066`*^9}, {3.570555519555103*^9, 
  3.570555522548274*^9}, {3.570796514971785*^9, 3.570796546575593*^9}, {
  3.5708069943391705`*^9, 3.5708070958879786`*^9}, {3.5708071281578245`*^9, 
  3.5708071292618876`*^9}, {3.570814709664462*^9, 3.5708147240482845`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"R", " ", "T", " ", 
   RowBox[{"Coth", "[", 
    RowBox[{"l", " ", 
     SqrtBox[
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
  RowBox[{"Co", " ", 
   SqrtBox["Dox"], " ", 
   SuperscriptBox["F", "2"], " ", 
   SqrtBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]], "Output",
 CellChangeTimes->{
  3.5705392149565334`*^9, 3.570539343543888*^9, 3.5705542143624496`*^9, {
   3.5705542553907967`*^9, 3.570554278495118*^9}, 3.5705543199654903`*^9, 
   3.570555127222663*^9, 3.57055532036771*^9, 3.5705555235353303`*^9, 
   3.57055556513371*^9, 3.5705571984211283`*^9, 3.570557235619256*^9, 
   3.5705572712172923`*^9, 3.570557954669383*^9, {3.570558093856344*^9, 
   3.570558132799572*^9}, 3.570796574837209*^9, {3.570807106310575*^9, 
   3.570807131521017*^9}, 3.5708073490324583`*^9, 3.5708074498372235`*^9, 
   3.57081473882813*^9, 3.5708148242600164`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zf", "=", 
  RowBox[{"Rct", "+", "Zw"}]}]], "Input",
 CellChangeTimes->{{3.5705543548144836`*^9, 3.5705543616518745`*^9}}],

Cell[BoxData[
 RowBox[{"Rct", "+", 
  FractionBox[
   RowBox[{"R", " ", "T", " ", 
    RowBox[{"Coth", "[", 
     RowBox[{"l", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
   RowBox[{"Co", " ", 
    SqrtBox["Dox"], " ", 
    SuperscriptBox["F", "2"], " ", 
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]], "Output",
 CellChangeTimes->{
  3.570554363002952*^9, 3.5705551272456636`*^9, 3.5705553204257135`*^9, 
   3.57055552685052*^9, 3.5705555651917133`*^9, 3.5705571984721317`*^9, 
   3.5705572356532583`*^9, 3.570557271260295*^9, 3.570557954715386*^9, {
   3.5705580938923464`*^9, 3.570558132861575*^9}, 3.570796595635399*^9, 
   3.5708071463708663`*^9, 3.57080734907146*^9, 3.5708074498762255`*^9, 
   3.5708147709599676`*^9, 3.570814824286018*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", "Zf"}], "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.570554375573671*^9, 3.5705544213962917`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox[
       RowBox[{"R", " ", "T", " ", 
        RowBox[{"Coth", "[", 
         RowBox[{"l", " ", 
          SqrtBox[
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
       RowBox[{"Co", " ", 
        SqrtBox["Dox"], " ", 
        SuperscriptBox["F", "2"], " ", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}]], "Output",
 CellChangeTimes->{3.570796818595151*^9, 3.5708071546633406`*^9, 
  3.570807349107462*^9, 3.5708074499162283`*^9, 3.5708147773023305`*^9, 
  3.5708148243250203`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.5705544366851664`*^9, 3.570554446386721*^9}}],

Cell[BoxData[
 RowBox[{"Re", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T", " ", 
         RowBox[{"Coth", "[", 
          RowBox[{"l", " ", 
           SqrtBox[
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.570554447671795*^9, 3.5705551273266687`*^9, 3.57055532054072*^9, 
   3.5705555653087196`*^9, 3.5705568274239087`*^9, 3.5705571985761375`*^9, 
   3.570557235721262*^9, 3.570557271341299*^9, 3.5705579548053913`*^9, {
   3.5705580939923525`*^9, 3.570558132978582*^9}, 3.5707968342810483`*^9, 
   3.5708071803678107`*^9, 3.570807349181466*^9, 3.5708074500122337`*^9, 
   3.5708148243530216`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Z", "]"}]}]], "Input",
 CellChangeTimes->{{3.570554449777915*^9, 3.5705544568673205`*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox[
        RowBox[{"R", " ", "T", " ", 
         RowBox[{"Coth", "[", 
          RowBox[{"l", " ", 
           SqrtBox[
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], "]"}]}], 
        RowBox[{"Co", " ", 
         SqrtBox["Dox"], " ", 
         SuperscriptBox["F", "2"], " ", 
         SqrtBox[
          RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], 
  "]"}]], "Output",
 CellChangeTimes->{
  3.5705544587714295`*^9, 3.570555127376672*^9, 3.5705553206007233`*^9, 
   3.570555565362723*^9, 3.5705568312251263`*^9, 3.5705571986381407`*^9, 
   3.570557235754264*^9, 3.5705572713763013`*^9, 3.5705579548483934`*^9, {
   3.5705580940273542`*^9, 3.5705581330375853`*^9}, 3.5707968400143766`*^9, 
   3.570807186182143*^9, 3.570807349222469*^9, 3.570807450058236*^9, 
   3.570814824378023*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5705544727082267`*^9, 3.5705544926593676`*^9}, {
  3.570554806084295*^9, 3.5705548115736084`*^9}}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T", " ", 
            RowBox[{"Coth", "[", 
             RowBox[{"l", " ", 
              SqrtBox[
               FractionBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
             "]"}]}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
    "2"], "+", 
   SuperscriptBox[
    RowBox[{"Re", "[", 
     RowBox[{"Rs", "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
        FractionBox["1", 
         RowBox[{"Rct", "+", 
          FractionBox[
           RowBox[{"R", " ", "T", " ", 
            RowBox[{"Coth", "[", 
             RowBox[{"l", " ", 
              SqrtBox[
               FractionBox[
                RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
             "]"}]}], 
           RowBox[{"Co", " ", 
            SqrtBox["Dox"], " ", 
            SuperscriptBox["F", "2"], " ", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
    "2"]}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9, 
   3.570807190127369*^9, 3.570807349278472*^9, 3.5708074501202397`*^9, 
   3.570814824428026*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T", " ", 
              RowBox[{"Coth", "[", 
               RowBox[{"l", " ", 
                SqrtBox[
                 FractionBox[
                  RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
               "]"}]}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
      "2"], "+", 
     SuperscriptBox[
      RowBox[{"Re", "[", 
       RowBox[{"Rs", "+", 
        FractionBox["1", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}], "+", 
          FractionBox["1", 
           RowBox[{"Rct", "+", 
            FractionBox[
             RowBox[{"R", " ", "T", " ", 
              RowBox[{"Coth", "[", 
               RowBox[{"l", " ", 
                SqrtBox[
                 FractionBox[
                  RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], "Dox"]]}], 
               "]"}]}], 
             RowBox[{"Co", " ", 
              SqrtBox["Dox"], " ", 
              SuperscriptBox["F", "2"], " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}]]}]]}]]}], "]"}], 
      "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{
  3.570554493429412*^9, 3.5705548131526985`*^9, 3.5705551274066734`*^9, 
   3.570555320663727*^9, 3.5705555654227266`*^9, 3.570557198701144*^9, 
   3.5705572357882657`*^9, 3.570557271410303*^9, 3.5705579548883963`*^9, {
   3.5705580940633564`*^9, 3.5705581330955887`*^9}, 3.570796842648527*^9, 
   3.570807190127369*^9, 3.570807349278472*^9, 3.5708074501202397`*^9, 
   3.5708148244310265`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.5705545122914906`*^9, 3.5705545204389567`*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{
  3.570554521526019*^9, 3.570555127457676*^9, 3.5705553207367315`*^9, 
   3.570555565496731*^9, 3.570557198785149*^9, 3.570557235825268*^9, 
   3.5705572714463053`*^9, 3.570557954939399*^9, {3.5705580941353607`*^9, 
   3.570558133168593*^9}, 3.570796845715702*^9, 3.570807199134884*^9, 
   3.5708073493374753`*^9, 3.5708074501822433`*^9, 3.570814824458028*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"20", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Dox", "=", 
  RowBox[{"1", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Co", "=", 
  RowBox[{"2", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"l", "=", "0.01"}], "\[IndentingNewLine]", 
 RowBox[{"F", "=", "96485"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "298.15"}], "\[IndentingNewLine]", 
 RowBox[{"R", "=", "8.31447"}]}], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
   3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
   3.570533164322457*^9}, {3.5705389117301893`*^9, 3.570538957625815*^9}, {
   3.5705545315715933`*^9, 3.5705545321316257`*^9}, {3.5705546440840287`*^9, 
   3.570554744162753*^9}, {3.570555291317048*^9, 3.5705552918600793`*^9}, {
   3.570558088948064*^9, 3.57055814814845*^9}, 3.5707968842859087`*^9, {
   3.570807239695204*^9, 3.57080727179004*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244920297`*^9}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.57081482449503*^9}],

Cell[BoxData[
 FractionBox["1", "50000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148244970303`*^9}],

Cell[BoxData[
 FractionBox["1", "100000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.57081482450103*^9}],

Cell[BoxData[
 FractionBox["1", "500000"]], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.57081482450403*^9}],

Cell[BoxData["0.01`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.57081482450603*^9}],

Cell[BoxData["96485"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148245210314`*^9}],

Cell[BoxData["298.15`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148245230317`*^9}],

Cell[BoxData["8.31447`"], "Output",
 CellChangeTimes->{{3.5705545981264*^9, 3.5705546126802325`*^9}, 
   3.570554720383393*^9, 3.5705547508661366`*^9, 3.5705551274966784`*^9, 
   3.5705553207967343`*^9, 3.5705555655787354`*^9, 3.570557198864154*^9, 
   3.57055723585927*^9, 3.5705572714863076`*^9, {3.5705579426746974`*^9, 
   3.570557954979401*^9}, {3.570558094196364*^9, 3.570558133229596*^9}, 
   3.570796888436146*^9, 3.5708072032181177`*^9, 3.570807276028282*^9, 
   3.5708073493894787`*^9, 3.5708074502422466`*^9, 3.5708148245260315`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "1"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}, 
   3.570539142100366*^9, {3.570554838147128*^9, 3.5705548545010643`*^9}, 
   3.5705548849028025`*^9, {3.570796901071869*^9, 3.5707969015338955`*^9}, {
   3.5708073179186783`*^9, 3.570807321903906*^9}, 3.5708148419040256`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k4VG8UB/AsZY/sauxjzZZ9LDmWbGHGbpAtikiLpdJGUtbyk0pSaENK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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 104.05097834232531`}, {-61.859766645240505`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5705572359982777`*^9, 3.570557271602314*^9, 3.5705579551504107`*^9, {
   3.5705580943653736`*^9, 3.5705581333856053`*^9}, {3.570796892456376*^9, 
   3.570796904154045*^9}, 3.570807208943445*^9, 3.5708072813775883`*^9, {
   3.5708073243270445`*^9, 3.57080734959549*^9}, 3.570807450351253*^9, {
   3.5708148246330376`*^9, 3.570814843993145*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.5705572046414843`*^9, 3.5705572046984873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "Zf", "]"}], ",", 
     RowBox[{"Im", "[", "Zf", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "1"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.570554936758769*^9, 3.57055496859659*^9}, {
   3.5707969178858304`*^9, 3.5707969214870367`*^9}, 3.5708149014894333`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Hk8ldv3B3DlRpNoQFFUpLmkQiGLY3qOYziH8zzIcGSKDKVSZApJfpLK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     "]]}},
  Axes->True,
  AxesOrigin->{50., 0},
  Method->{},
  PlotRange->{{50.02977177913441, 94.10218032142161}, {-54.56505848587345, 
   0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236051281*^9, 3.570557271666318*^9, 3.570557955226415*^9, {
   3.5705580944143763`*^9, 3.5705581334366083`*^9}, 3.570796923273138*^9, {
   3.5708073385868607`*^9, 3.5708073496454926`*^9}, 3.5708074504012556`*^9, 
   3.5708148247140427`*^9, 3.570814903420544*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.570557207026621*^9, 3.5705572070806236`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox[
           RowBox[{"42.10365382785329`", " ", 
            RowBox[{"Coth", "[", 
             RowBox[{"0.01`", " ", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["10", 
                 RowBox[{"5", "+", "lom"}]]}]]}], "]"}]}], 
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "5"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox[
            RowBox[{"42.10365382785329`", " ", 
             RowBox[{"Coth", "[", 
              RowBox[{"0.01`", " ", 
               SqrtBox[
                RowBox[{"\[ImaginaryI]", " ", 
                 SuperscriptBox["10", 
                  RowBox[{"5", "+", "lom"}]]}]]}], "]"}]}], 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}]], "]"}]}], 
  "\[Pi]"]], "Output",
 CellChangeTimes->{
  3.5705341416623573`*^9, 3.5705342311404753`*^9, 3.570535231352684*^9, 
   3.570539161852496*^9, 3.570539343825904*^9, 3.57055489307027*^9, 
   3.570555127712691*^9, 3.5705553209927454`*^9, 3.5705555658767524`*^9, 
   3.570557199095167*^9, 3.5705572360782824`*^9, 3.5705572716983194`*^9, 
   3.570557955257417*^9, {3.570558094444378*^9, 3.57055813346661*^9}, 
   3.5707969350128098`*^9, 3.5708073496724944`*^9, 3.5708074504282575`*^9, 
   3.5708148247580447`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}, 3.570555008228857*^9, 
   3.5707969433742886`*^9, 3.5708149232166767`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt23c8le/7AHB773GOY4/IKjJT9NzESYNkHBIqJCTUJxSVUVJSpJIVIhlJ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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-6., 6.}, {-89.99955091200633, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.570557236110284*^9, 3.570557271809326*^9, 3.5705579553724236`*^9, {
   3.570558094558385*^9, 3.570558133580617*^9}, 3.570796945274397*^9, 
   3.5708073498115025`*^9, 3.5708074505602646`*^9, 3.570814824904053*^9, 
   3.5708149253728*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "lZM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5707969728999767`*^9, 3.570797001887635*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4Fd8bAPB77bu7X1GyJUtKQkKdtyxJUmSrKIlChVApvqiQNiRFFEVk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     "]]}},
  Axes->True,
  AxesOrigin->{0, 1.},
  Method->{},
  PlotRange->{{-4., 6.}, {1.00000759871088, 5.124204297877222}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5707970045507874`*^9, 3.5708073499755116`*^9, 
  3.5708074507132735`*^9, 3.5708148250600624`*^9, 3.5708149435658407`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "4"}], ",", "6", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}, 3.5705394635877542`*^9, {3.57053949726768*^9, 
   3.57053949778371*^9}, {3.570539586787801*^9, 3.570539603699768*^9}, 
   3.5705397446258287`*^9, 3.5707970178545485`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<FLreflect-Mat.txt\>\"", ",", "res", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}, {3.570539502739993*^9, 
   3.570539506052183*^9}, 3.57053956107633*^9, {3.570539655171712*^9, 
   3.570539663507189*^9}, 3.5705397519122453`*^9, {3.570555063732031*^9, 
   3.5705550730595646`*^9}, {3.5707970342074833`*^9, 3.570797034910524*^9}, {
   3.570807404896653*^9, 3.5708074258878536`*^9}, {3.5708148128803654`*^9, 
   3.5708148150724907`*^9}}],

Cell[BoxData["\<\"FLreflect-Mat.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9, 
   3.570539344568947*^9, 3.570539511388488*^9, 3.570539566442637*^9, 
   3.57053967402779*^9, 3.570539755160431*^9, 3.570539785664176*^9, 
   3.5705550796219397`*^9, 3.5705551278827004`*^9, 3.5705553211777563`*^9, 
   3.5705555661347675`*^9, 3.5705571992251744`*^9, 3.5705572361762877`*^9, 
   3.5705572718723297`*^9, 3.5705579554434276`*^9, {3.570558094625388*^9, 
   3.5705581336466208`*^9}, 3.570797038781745*^9, 3.57080735082156*^9, {
   3.5708074135581484`*^9, 3.5708074508432813`*^9}, 3.570814825118066*^9, 
   3.5708149517153063`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["\[AliasDelimiter]"], "Input",
 CellChangeTimes->{3.5708074561225834`*^9}],

Cell[BoxData["\[AliasDelimiter]"], "Output",
 CellChangeTimes->{3.5708148251500673`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.6000001430511475`,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 851, 16, 186, "Title"],
Cell[CellGroupData[{
Cell[1443, 42, 589, 10, 164, "Input"],
Cell[2035, 54, 1997, 29, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4069, 88, 1896, 30, 54, "Input"],
Cell[5968, 120, 614, 12, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6619, 137, 726, 15, 47, "Input"],
Cell[7348, 154, 948, 21, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8333, 180, 146, 3, 47, "Input"],
Cell[8482, 185, 839, 20, 95, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9358, 210, 308, 9, 47, "Input"],
Cell[9669, 221, 769, 21, 126, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10475, 247, 147, 3, 47, "Input"],
Cell[10625, 252, 1068, 27, 126, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11730, 284, 147, 3, 75, "Input"],
Cell[11880, 289, 1067, 27, 201, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12984, 321, 365, 9, 123, "Input"],
Cell[13352, 332, 1919, 53, 220, "Output"],
Cell[15274, 387, 2094, 56, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17405, 448, 152, 3, 75, "Input"],
Cell[17560, 453, 435, 7, 78, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18032, 465, 1182, 25, 448, "Input"],
Cell[19217, 492, 538, 7, 75, "Output"],
Cell[19758, 501, 535, 7, 75, "Output"],
Cell[20296, 510, 561, 8, 105, "Output"],
Cell[20860, 520, 559, 8, 105, "Output"],
Cell[21422, 530, 559, 8, 105, "Output"],
Cell[21984, 540, 538, 7, 75, "Output"],
Cell[22525, 549, 541, 7, 75, "Output"],
Cell[23069, 558, 543, 7, 75, "Output"],
Cell[23615, 567, 544, 7, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24196, 579, 1469, 24, 75, "Input"],
Cell[25668, 605, 15039, 253, 572, "Output"]
}, Open  ]],
Cell[40722, 861, 96, 1, 75, "Input"],
Cell[CellGroupData[{
Cell[40843, 866, 430, 11, 75, "Input"],
Cell[41276, 879, 4936, 88, 1137, "Output"]
}, Open  ]],
Cell[46227, 970, 94, 1, 75, "Input"],
Cell[CellGroupData[{
Cell[46346, 975, 395, 8, 75, "Input"],
Cell[46744, 985, 2248, 60, 350, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49029, 1050, 960, 17, 75, "Input"],
Cell[49992, 1069, 17533, 295, 1196, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67562, 1369, 293, 8, 75, "Input"],
Cell[67858, 1379, 10332, 175, 449, "Output"]
}, Open  ]],
Cell[78205, 1557, 1163, 22, 75, "Input"],
Cell[CellGroupData[{
Cell[79393, 1583, 705, 12, 75, "Input"],
Cell[80101, 1597, 1702, 24, 75, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81840, 1626, 87, 1, 75, "Input"],
Cell[81930, 1629, 88, 1, 75, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
